Imports System.IO

Partial Class Upload_file
    Inherits System.Web.UI.Page

    Protected Sub BtnUploadFile_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles BtnUploadFile.Click

        ' This code gets the filename in the "FileUpload" textbox when the user has clicked the
        ' "btnUploadFile" button and saves this file to the "files" folder on the webserver with 
        ' the same name as the original filename. Note that you need to have the "files" folder to be able 
        ' to save the file.

        Try
            If Not FileUpload.PostedFile Is Nothing Then
                Dim FileName As String = Path.GetFileName(FileUpload.PostedFile.FileName)
                FileUpload.PostedFile.SaveAs(Server.MapPath("files/") & FileName)
                Message.Text = "Your file has been uploaded successfully"
            Else
                Throw New Exception()
            End If
        Catch ex As Exception
            Message.Text = "The file could not be uploaded, the errormessage is: " & ex.ToString()
        End Try
    End Sub

    Protected Sub btnShowList_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnShowList.Click

        ' This code looks in the "files" folder on the webserver when the user has clicked a button and
        ' then gets the names on all the files in this folder. The name on the files are presented
        ' as LinkButtons in the repeater with the name "FilesRepeater".

        Dim FilesInFolder As New DirectoryInfo(Server.MapPath("files/"))

        FilesRepeater.DataSource = FilesInFolder.GetFiles("*")
        FilesRepeater.DataBind()

    End Sub

    Protected Sub DownLoadLinkButton_Click(ByVal sender As Object, ByVal e As CommandEventArgs)

        ' When the user has clicked a LinkButton for a file we get the name of the file by a
        ' CommandArgument and then uses this name to make it possible for the user to download
        ' the file.

        Try
            Dim FileName As String = "files/" & (e.CommandArgument).ToString()
            Dim LookForFile As FileInfo = New FileInfo(Server.MapPath(FileName))

            If LookForFile.Exists Then

                ' Give the user a Save As Dialog to download the text file. The term "octet-stream" means 
                ' that file could be of any type with any extension.

                Response.Clear()
                Response.ContentType = ("application/octet-stream")
                Response.AppendHeader("Content-Disposition", "attachment; filename=" & (e.CommandArgument).ToString())
                Response.WriteFile(Server.MapPath(FileName))
                Response.Flush()
                Response.Close()
            Else
                Throw New FileNotFoundException()
            End If
        Catch ex As FileNotFoundException
            Message2.Text = "The file could not be downloaded, the errormessage is: " & ex.ToString()
        Finally
        End Try
    End Sub
End Class
